//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//
using System;
using System.ComponentModel;
using System.Globalization;

namespace FrameworkLibraries
{
	public class Complex
	{
		private double re;
		private double im;
		public Complex(double re, double im)
		{
			this.re = re;
			this.im = im;
		}
		public double Real
		{
			get
			{
				return re;
			}
			set
			{
				re = value;
			}
		}
		public double Imaginary
		{
			get
			{
				return im;
			}
			set
			{
				im = value;
			}
		}
		public override string ToString()
		{
			return string.Format("{0},{1}", re, im);
		}
		public string ToString(string format)
		{
			if (format.Equals ("p"))
			{
				return string.Format("{0},{1}",
					                 Math.Sqrt(re*re + im*im),
					                 Math.Atan2(im,re));
			}
			else
			{
				return ToString();
			}
		}
	}
	public class CustomFormatMain 
	{
		static void Main(string [] args)
		{
			Complex c = new Complex(3,4);
			Console.WriteLine("{0} -> {1}", c, c.ToString("p"));
		}
	}
}